﻿/*	VERSION:	1.2
	1.2		Change:	Failure returns undefined instead of an error string,  because I typically test for failure by looking for undefined or falsey values.

USAGE
	#include "functions/VOW.as"
	#include "functions/VOW/loadFile.as"
	
	loadFile("file 2.txt")
		.then( function(file_str){
			trace(file_str);
		} );
*/
var loadFile = function( fileName ){
	var vow = VOW.make();
	var loader = new XML();
	loader.onData = function(result){
		if(result==undefined){
			var reason = "Could not load:  "+fileName;
			vow.doBreak( undefined );
		}
		else
		{
			var enter13 = String.fromCharCode(13);
			result = result.split(enter13).join('');
			vow.keep(result);
		}
	}// success();
	loader.load(fileName);
	return vow.promise;
}// loadFile()